//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "..\Defines.mqh"
#include "..\SQL\C_ReplayDataBase.mqh"
//+------------------------------------------------------------------+
#resource "Script.sql" as string SQL_01
//+------------------------------------------------------------------+
class C_InServer : public C_ReplayDataBase
{
	private	:
		bool	m_IsReplay;
		struct stLocal
		{
			ulong 	numberMagic,
						ticket;
			int   	type;
			double 	volume,
						price,
						sl,
						tp;
		}m_Info;
	public	:
//+------------------------------------------------------------------+
		C_InServer()
			:C_ReplayDataBase(),
			m_IsReplay(_Symbol == def_SymbolReplay)
		{
			ZeroMemory(m_Info);
			ExecResourceSQL(SQL_01);
		}
//+------------------------------------------------------------------+
	inline const double _PositionGetDouble(ENUM_POSITION_PROPERTY_DOUBLE arg)
	{	
		if (!m_IsReplay)
			return PositionGetDouble(arg);
			
		switch (arg)
		{
			case POSITION_VOLUME			: return m_Info.volume;
			case POSITION_PRICE_OPEN	: return m_Info.price;
			case POSITION_SL				: return m_Info.sl;
			case POSITION_TP				: return m_Info.tp;
			case POSITION_PRICE_CURRENT: break;
			case POSITION_SWAP			: break;
			case POSITION_PROFIT			: break;
		}
		
		return 0;
	}
//+------------------------------------------------------------------+
	inline const long _PositionGetInteger(ENUM_POSITION_PROPERTY_INTEGER arg)
	{
		if (!m_IsReplay)
			return PositionGetInteger(arg);
			
		switch (arg)
		{
			case POSITION_TICKET				: return (long) m_Info.ticket;
			case POSITION_TIME				: break;
			case POSITION_TIME_MSC			: break;
			case POSITION_TIME_UPDATE		: break;
			case POSITION_TIME_UPDATE_MSC	: break;
			case POSITION_TYPE				: return (long) m_Info.type;
			case POSITION_MAGIC				: return (long) m_Info.numberMagic;
			case POSITION_IDENTIFIER		: break;
		}
		
		return 0;
	}
//+------------------------------------------------------------------+
	inline const bool _PositionSelectByTicket(ulong arg)
	{
		bool ret;
		
		if (!m_IsReplay)
			return PositionSelectByTicket(arg);

		ZeroMemory(m_Info);		
		if (!ExecRequestOfData(StringFormat("SELECT * FROM tb_Replay AS tb WHERE (tb.history = 0) AND (tb.ticket = %d);", arg)))
		{
 			Print("Error in accessing the database...");
 			return false;
 		}
		
		ret = GetRegisterOfRequest(m_Info);

		return ret;
	}
//+------------------------------------------------------------------+
	inline const string _PositionGetString(ENUM_POSITION_PROPERTY_STRING arg)
	{
		if (!m_IsReplay)
			return PositionGetString(arg);
			
		switch (arg)
		{
			case POSITION_SYMBOL		 :return def_SymbolReplay;
			case POSITION_COMMENT	 :break;
			case POSITION_EXTERNAL_ID:break;
		}
		
		return "";
	}
//+------------------------------------------------------------------+
	inline const string _PositionGetSymbol(int arg)
	{
		return (!m_IsReplay ? PositionGetSymbol(arg) : (_PositionGetTicket(arg) > 0 ? def_SymbolReplay : ""));
	}
//+------------------------------------------------------------------+
	inline const int _PositionsTotal(void)
	{
#define macro_ERROR { Print("Error in accessing the database..."); return 0; }
		
		struct stLocal
		{
			int value;
		}Info;
		
		if (!m_IsReplay)
			return PositionsTotal();

		if (!ExecRequestOfData("SELECT COUNT(*) FROM tb_Replay AS tb WHERE tb.history = 0;")) macro_ERROR
		if (!GetRegisterOfRequest(Info)) macro_ERROR
			
		return Info.value;
		
#undef macro_ERROR
	}
//+------------------------------------------------------------------+
	inline const ulong _PositionGetTicket(int arg)
	{
#define macro_ERROR { Print("Error in accessing the database..."); return 0; }
		
		bool bRet;
				
		if (!m_IsReplay)
			return PositionGetTicket(arg);

		ZeroMemory(m_Info);
		if (!ExecRequestOfData("SELECT * FROM tb_Replay AS tb WHERE tb.history = 0;")) macro_ERROR
		for (int c = 0; (bRet = GetRegisterOfRequest(m_Info)) && (c < arg); c++);
		return (bRet ? m_Info.ticket : 0);
		
#undef macro_ERROR
	}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+